library test;

uses
  SysUtils,
  Classes,
  Windows,
  Messages,
  ShellApi,
  PluginsDef in 'PluginsDef.pas';

{$E sfm}
{$R test.res}

var
  AddrList: TStringList;
  LogFileName: String;

function GetModuleInfo: TModuleInfo; stdcall;
begin
  FillMemory(@Result,SizeOf(Result),0);
  with Result do begin
    Name:= 'Test SDK';                       // Nazwa moduu
    Version:= 10;                            // Wersja moduu
    ServerVersion:= SFW_API_VER;             // Prosz nie zmienia rcznie
    Copyrights:= 'Copyright  2004 Ja :-)';  // Informacja o prawach autorskich
    Contact:= 'www.myaddress.pl';            // Adres autora
    ShortDesc:= 'Przykadowy modu';         // Opis moduu
    RequestedMsgs:= SM_ALL;                  // Podane informacje, np.: SM_REQUEST or SM_LOAD or SM_UNLOAD;
    ResultSignificance:= PR_NONE;            // Wano moduu
  end;
end;


function ProccessMessage(Msg: DWord; Param1: DWord; Param2: DWord): DWord; stdcall;
var
  RequestInfo: PRequestInfo;
  Block: Boolean;
begin
  Result:= 0;
  case Msg of
    SM_LOAD: begin
      // Wczytanie konfiguracji;
      MessageBox(0,'SM_LOAD','Modu Test',0);
      AddrList:= TStringList.Create;
      LogFileName:= ChangeFileExt(pChar(Param1),'_log.txt');
    end;
    SM_REQUEST: begin
      RequestInfo:= Pointer(Param1);
      MessageBox(0,PChar('SM_REQUEST'#13#10+RequestInfo.riMethod+': '+RequestInfo.riRequestURI),'Test',0);
      Block:= RequestInfo.ciClientAddr <> '127.0.0.1';
      if Block then begin
        MessageBox(0,'403 Forbidden','Modu Test',0);
        RequestInfo.saAction:= AC_ERROR;
        RequestInfo.saParam[0]:= 403;
        RequestInfo.saActionStr:= 'danie zostao zablokowane przez modu Testowy.';
        AddrList.Add(RequestInfo.ciClientAddr)
      end;
    end;
    SM_UNLOAD: begin
      MessageBox(0,'SM_UNLOAD','Test',0);
      AddrList.SaveToFile(LogFileName);
      AddrList.Free;
    end;
    SM_CLIENTCONNECT: begin
      MessageBox(0,'SM_CLIENTCONNECT','Modu Test',0);
    end;
    SM_CLIENTDISCONNECT: begin
      MessageBox(0,'SM_CLIENTDISCONNECT','Modu Test',0);
    end;
  end;
end;


function ShowConfig(Path: pChar; Param: DWord): DWord; stdcall;
begin
  Result:= 0;
  MessageBox(0,'Prosty dialog konfiguracyjny :)','Modu Test',0);
end;

function ShowInfo(Param: DWord): DWord; stdcall;
var
  HelpFileName: pChar;
begin
  Result:= 0;
  HelpFileName:= pChar(Pointer(Param));
  HelpFileName:= pChar(ChangeFileExt(String(HelpFileName),'.chm'));
  ShellExecute(hInstance,'open',HelpFileName,'','',SW_NORMAL);
end;

exports
  GetModuleInfo,
  ProccessMessage,
  ShowConfig,
  ShowInfo;


begin

end.
