//
//  Alacer 2.0
//  API moduw
//

unit PluginsDef;

interface

uses
  Types;

const

  { Wersja API }

  SFW_API_VER =        14;

  { Informacje przekazywane do moduu }

  SM_LOAD =             1;       // Podczenie moduu, po uruchomieniu serwera
  SM_UNLOAD =           2;       // Odczenie moduu, po zatrzymaniu serwera
  SM_CLIENTCONNECT =    4;       // Podczenie klienta
  SM_CLIENTDISCONNECT = 8;       // Odczenie klienta
  SM_BEFOREREQUEST =   16;       // Info wysyane jeszcze przed przetwarzaniem dania, mona zmieni np server root
  SM_REQUEST =         32;       // Przetwarzanie dania
  SM_ALL =            256;       // Wszystkie

  { Rodzaj odpowiedzi }

  AC_NONE =           0;         // Modu zignorowa danie, sterowanie zostanie przekazane kolejnemu moduowi. Jeeli aden z moduw nie wpynie na zapytanie, w domylny sposb odpowie na nie serwer.
  AC_ERROR =          1;         // Modu odpowiedzia bdem.
  AC_DONE =           2;         // Narazie naley przyj, e warto nieuywana.
  AC_SENDHTML =       3;         // Modu umieci w saAnswBuffer kod html do wysania. Nagwek utworzy automatycznie serwer.
  AC_SENDHTTP =       4;         // Modu umieci w saAnswBuffer odpowied HTTP cznie z fragmentami nagwka (np. dat), serwer zmodyfikuje nagwek o wymagane pola.
  AC_SENDHTTPCL =     5;         // Modu umieci w saAnswBuffer pen odpowied cznie z nagwkiem HTTP, serwer NIE BDZIE ju jej modyfukowa przed wysaniem.

  { Priorytet moduw }
  { Okrela kolejno, wedug ktrej moduy bd przetwaa dania }
  { Naley zwrci uwag, e najpierw przetwarzane s WSZYSTKIE moduy z PR_NONE, }
  { nastpnie kolejno wedug malejcego stopnia wanoci od PR_MODIFY_LEVEL1 do PR_MODIFY_LEVEL9. }
  { Jest to istatne, gdy jeeli ktry modu odpowie, (tzn saAction <> AC_NONE) }
  { dalsze przetwarzanie jest przerywane i do klienta wysyana jest odpowied }

  PR_NONE =          0;          // Brak zmian, modu nie wpywa na przetwarzanie dania i dlatego bdzie zawsze wywoywany w pierwszej kolejnoci.
  PR_MODIFY_LEVEL1 = 1;          // Istotna, np. blokowanie okrelonych adresw IP ktre musz by wykonane w pierwszej kolejnoci.
  PR_MODIFY_LEVEL2 = 2;
  PR_MODIFY_LEVEL3 = 3;
  PR_MODIFY_LEVEL4 = 4;
  PR_MODIFY_LEVEL5 = 5;
  PR_MODIFY_LEVEL6 = 6;
  PR_MODIFY_LEVEL7 = 7;
  PR_MODIFY_LEVEL8 = 8;
  PR_MODIFY_LEVEL9 = 9;          // Nieistotne, np. wywietlenie zawartoci katalogu



  SA_CREATED_NORMAL = 0;
  SA_CREATED_DYNAMICAL = 1;      // Odpowied stworzona dynamicznie, serwer nie bdzie podawa czasu modyfikacji dokumentu (tak, aby funkcje keszujce dziaay poprawnie).

type

  TParams = array [0..3] of Integer;

  TAnswBuffer = array of Char;

  PBeforeRequestInfo = ^TBeforeRequestInfo;
  TBeforeRequestInfo = packed record
    RequestHost: String;
    Root: String;
    ClientAddr: String;
    ClientPort: String;
    UserAgent: String;
  end;

  PRequestInfo = ^TRequestInfo;
  TRequestInfo = packed record
    Version: Byte;
    // Request info
    riAccept: String;
    riAcceptEncoding: String;
    riAcceptLanguage: String;
    riAuthorization: String;
    riCache: String;
    riConnection: String;
    riContentType: String;
    riCookie: String;
    riDocument: String;      // Zdekodowany dokument
    riDocumentExt: String;   // Rozszerzenie dokumentu
    riMethod: String;        // Metoda dania HTTP (GET, POST)
    riParams: String;
    riPath: String;
    riPostData: String;
    riPostDataSize: Integer;
    riRealDocument: String;  // Rzeczywista cieka do dokumentu na dysku (po przetworzeniu /../ itp).
    riReferer: String;
    riRequestHost: String;
    riRequestURI: String;
    riVersion: String;       // Wersja HTTP

    // Server info (local)
    siAdminMail: String;
    siRoot: String;
    siRootOnly: Boolean;
    siServerAddr: String;
    siServerName: String;
    siServerPort: String;
    siSignature: String;
    siSoftware: String;

    // Client info (remote)
    ciClientAddr: String;
    ciClientPort: String;
    ciUserAgent: String;

    // Server action def.
    saAction: Integer;          // Akcja do wykonania przez serwer
    saActionStr: String;        // Opis akcji
    saHeader: String;           // Linie do dodania do nagwka HTTP
    saAnswBuffer: String;       // Bufor odpowiedzi
    saParam: TParams;           // Dodatkowe parametery
  end;

  PClientInfo = ^TClientInfo;
  TClientInfo = packed record
    RemoteAddr: String;
    RemotePort: String;
    LocalAddr: String;
    LocalPort: String;
  end;

  PModuleInfo = ^TModuleInfo;
  TModuleInfo = packed record
    Name: String[20];
    Version: Integer;
    ServerVersion: Integer;
    Copyrights: String[50];
    Contact: String[50];
    ShortDesc: String[100];
    RequestedMsgs: Integer;
    ResultSignificance: Integer;
  end;

implementation

end.
 